/********************************************
; File: Control.h
;
;
; Copyright Apple Computer, Inc.1986-90
; All Rights Reserved
;
********************************************/

#ifndef __TYPES__
#include <TYPES.h>
#endif

#ifndef __QUICKDRAW__
#include <QUICKDRAW.h>
#endif

#ifndef __EVENT__
#include <EVENT.h>
#endif

#ifndef __CONTROL__
#define __CONTROL__


/* Axis Parameters */
#define noConstraint 0x0000  /* No constraint on movement. */
#define hAxisOnly 0x0001  /* Horizontal axis only. */
#define vAxisOnly 0x0002  /* Vertical axis only. */

/* CtlFlag */
#define simpRound 0x0000  /* Simple button flag */
#define upFlag 0x0001  /* Scroll bar flag.  */
#define boldButton 0x0001  /* Bold round cornered outlined button. */
#define simpBRound 0x0001  /* Simple button flag */
#define downFlag 0x0002  /* Scroll bar flag. */
#define simpSquare 0x0002  /* Simple button flag */
#define simpDropSquare 0x0003  /* Simple button flag */
#define leftFlag 0x0004  /* Scroll bar flag. */
#define rightFlag 0x0008  /* Scroll bar flag. */
#define dirScroll 0x0010  /* Scroll bar flag. */
#define horScroll 0x0010  /* Scroll bar flag. */
#define family 0x007F  /* Mask for radio button family number */
#define ctlInVis 0x0080  /* invisible mask for any type of control  */
#define fCallWindowMgr 0x0001  /* Control Template flag value */
#define fSubstituteText 0x0002
#define fSubTextType 0x0001
#define inListBox 0x88

/* CtlProc Codes */
#define simpleProc 0x00000000L
#define checkProc 0x02000000L
#define radioProc 0x04000000L
#define scrollProc 0x06000000L
#define growProc 0x08000000L

/* DefProc Commands */
#define drawCtl 0x0000  /* Draw control command. */
#define calcCRect 0x0001  /* Compute drag RECT command. */
#define testCtl 0x0002  /* Hit test command. */
#define initCtl 0x0003  /* Initialize command. */
#define dispCtl 0x0004  /* Dispose command. */
#define posCtl 0x0005  /* Move indicator command. */
#define thumbCtl 0x0006  /* Compute drag parameters command. */
#define dragCtl 0x0007  /* Drag command. */
#define autoTrack 0x0008  /* Action command. */
#define newValue 0x0009  /* Set new value command. */
#define setParams 0x000A  /* Set new parameters command. */
#define moveCtl 0x000B  /* Move command. */
#define recSize 0x000C  /* Return record size command. */
#define ctlHandleEvent 0x000D  /* Handle a keystroke or menu selection */
#define ctlChangeTarget 0x000E  /* Issued when control's target status has changed */
#define ctlChangeBounds 0x000F  /* Issued when control's boundary rectangle has changed */
#define ctlWindChangeSize 0x0010  /* Window has been grown or zoomed */
#define ctlHandleTab 0x0011  /* Control has been tabbed to */
#define ctlNotifyMultiPart 0x0012  /* A multipart control has been hidden, drawn or shown */
#define ctlWinStateChange 0x0013  /* Window state has changed */

/* hiliteState Codes */
#define noHilite 0x0000  /* Param to HiliteControl */
#define inactiveHilite 0x00FF  /* Param to HiliteControl */

/* PartCode Numbers */
#define noPart 0x0000
#define simpleButton 0x0002
#define checkBox 0x0003
#define radioButton 0x0004
#define upArrow 0x0005
#define downArrow 0x0006
#define pageUp 0x0007
#define pageDown 0x0008
#define growBox 0x000A
#define thumb 0x0081

/* moreFlags Codes */
#define fCtlTarget 0x8000  /* is current target of typing commands */
#define fCtlCanBeTarget 0x4000  /* can be made the target control */
#define fCtlWantEvent 0x2000  /* control can be called view SendEventToCtl */
#define fCtlWantsEvent 0x2000  /* control can be called view SendEventToCtl */
#define fCtlWantEvents 0x2000  /* control can be called view SendEventToCtl */
#define fCtlWantsEvents 0x2000  /* control can be called view SendEventToCtl */
#define fCtlProcRefNotPtr 0x1000  /* set = ID of defproc, clear = pointer to defproc */
#define fCtlTellAboutSize 0x0800  /* set if ctl needs notification when size of owning window changes */
#define fCtlIsMultiPart 0x0400  /* set if ctl needs notification to be hidden */
#define fMenuDefIsText 0x0004
#define colorDescriptor 0x000C  /* indicates type of reference in colorRef */
#define styleDescriptor 0x0003  /* indicates type of reference in styleRef */

/* Ctl Verbs */
#define titleIsPtr 0x00
#define titleIsHandle 0x01
#define titleIsResource 0x02
#define colorTableIsPtr 0x00
#define colorTableIsHandle 0x04
#define colorTableIsResource 0x08
#define ctlHideCtl 0x12

/* InputVerb Codes */
#define singlePtr 0x0000
#define singleHandle 0x0001
#define singleResource 0x0002
#define ptrToPtr 0x0003
#define ptrToHandle 0x0004
#define ptrToResource 0x0005
#define handleToPtr 0x0006
#define handleToHandle 0x0007
#define handleToResource 0x0008
#define resourceToResource 0x0009

/* ProcRefs */
#define simpleButtonControl 0x80000000L
#define checkControl 0x82000000L
#define radioControl 0x84000000L
#define scrollBarControl 0x86000000L
#define growControl 0x88000000L
#define statTextControl 0x81000000L
#define editLineControl 0x83000000L
#define editTextControl 0x85000000L
#define popUpControl 0x87000000L
#define listControl 0x89000000L
#define iconButtonControl 0x07FF0001L
#define pictureControl 0x8D000000L

/* Error Codes */
#define wmNotStartedUp 0x1001  /* Window manager was not initialized */
#define cmNotInitialized 0x1002  /* Control manager was not initialized */
#define noCtlInList 0x1003  /* Control not in window list */
#define noCtlError 0x1004  /* no controls in window */
#define noSuperCtlError 0x1005  /* no super controls in window */
#define noCtlTargetError 0x1006  /* no target super control */
#define notSuperCtlError 0x1007  /* action can only be done on super control */
#define canNotBeTargetError 0x1008  /* conrol cannot be made target */
#define noSuchIDError 0x1009  /* specified ID cannot be found */
#define tooFewParmsError 0x100A  /* not enough params specified */
#define noCtlToBeTargetError 0x100B  /* NextCtl call, no ctl could be target */
#define noFrontWindowError 0x100C  /* there is no front window */

/* displayMode flags */
#define selectedIcon 0x0001
#define openIcon 0x0002
#define offline 0x0004

/* listType values */
#define fListString 0x0001
#define fListSelect 0x0002
#define fListScrollBar 0x0004

/* PopUp control flag values */
#define fRightJustifyResult 0x0001
#define fRightJustifyTitle 0x0002
#define fInWindowOnly 0x0004
#define fDontDrawResult 0x0008
#define fDontDrawTitle 0x0010
#define fDontHiliteTitle 0x0020
#define fType2PopUp 0x0040
#ifndef WindowPtr
typedef GrafPortPtr WindowPtr;
#endif

struct BarColors {
   Word barOutline; /* color for outlining bar, arrows, and thumb */
   Word barNorArrow; /* color of arrows when not highlighted */
   Word barSelArrow; /* color of arrows when highlighted */
   Word barArrowBack; /* color of arrow box's background */
   Word barNorThumb; /* color of thumb's background when not highlighted */
   Word barSelThumb; /* color of thumb's background when highlighted */
   Word barPageRgn; /* color and pattern page region: high byte - 1= dither, 0 = solid */
   Word barInactive; /* color of scroll bar's interior when inactive */
} ;
typedef struct BarColors BarColors, *BarColorsPtr, **BarColorsHndl;

struct BoxColors {
   Word boxReserved; /* reserved */
   Word boxNor; /* color of box when not checked */
   Word boxSel; /* color of box when checked */
   Word boxTitle; /* color of check box's title */
} ;
typedef struct BoxColors BoxColors, *BoxColorsPtr, **BoxColorsHndl;

struct BttnColors {
   Word bttnOutline; /* color of outline */
   Word bttnNorBack; /* color of background when not selected */
   Word bttnSelBack; /* color of background when selected */
   Word bttnNorText; /* color of title's text when not selected */
   Word bttnSelText; /* color of title's text when selected */
} ;
typedef struct BttnColors BttnColors, *BttnColorsPtr, **BttnColorsHndl;

struct CtlRec {
   struct CtlRec **ctlNext; /* Handle of next control. */
   WindowPtr ctlOwner; /* Pointer to control's window. */
   Rect ctlRect; /* Enclosing rectangle. */
   Byte ctlFlag; /* Bit flags. */
   Byte ctlHilite; /* Highlighted part. */
   Word ctlValue; /* Control's value. */
   LongProcPtr ctlProc; /* Control's definition procedure. */
   LongProcPtr ctlAction; /* Control's action procedure. */
   Longint ctlData; /* Reserved for CtrlProc's use. */
   Longint ctlRefCon; /* Reserved for application's use. */
   Pointer ctlColor; /* Pointer to appropriate color table. */
   Byte ctlReserved[16]; /* Reserved for future expansion */
   LongWord ctlID; /*  */
   Word ctlMoreFlags; /*  */
   Word ctlVersion; /*  */
} ;
typedef struct CtlRec CtlRec, *CtlRecPtr, **CtlRecHndl, ***CtlRecHndlPtr;

struct LimitBlk {
   Rect boundRect; /* Drag bounds. */
   Rect slopRect; /* Cursor bounds. */
   Word axisParam; /* Movement constrains. */
   Pointer dragPatt; /* Pointer to 32 byte Pattern for drag outline. */
} ;
typedef struct LimitBlk LimitBlk, *LimitBlkPtr, **LimitBlkHndl;

struct RadioColors {
   Word radReserved; /* reserved */
   Word radNor; /* color of radio button when off */
   Word radSel; /* color of radio button when on */
   Word radTitle; /* color of radio button's title text */
} ;
typedef struct RadioColors RadioColors, *RadioColorsPtr, **RadioColorsHndl;

struct KeystrokeRec {
   Byte key1; /*   */
   Byte key2; /*   */
   Word keyModifiers; /*   */
   Word keyCareBits; /*   */
} ;
typedef struct KeystrokeRec KeystrokeRec;

struct ControlTemplate {
   Word pCount; /*   */
   LongWord ID; /*   */
   Rect rect; /*   */
   LongWord procRef; /*   */
   Word flag; /*   */
   Word moreFlags; /*   */
   LongWord refCon; /*   */
} ;
typedef struct ControlTemplate ControlTemplate;

struct SimpleButtonTemplate {
   ControlTemplate ctlTemplate; /*   */
   Ref titleRef; /*   */
   Ref colorTableRef; /*   */
   KeystrokeRec keyEquivalent; /*   */
} ;
typedef struct SimpleButtonTemplate SimpleButtonTemplate;

struct CheckBoxTemplate {
   ControlTemplate ctlTemplate; /*   */
   Ref titleRef; /*   */
   Word initalValue; /*   */
   Ref colorTableRef; /*   */
   KeystrokeRec keyEquivalent; /*   */
} ;
typedef struct CheckBoxTemplate CheckBoxTemplate;

struct IconButtonTemplate {
   ControlTemplate ctlTemplate; /*   */
   Ref iconRef; /*   */
   Ref titleRef; /*   */
   Ref colorTableRef; /*   */
   Word displayMode; /*   */
   KeystrokeRec keyEquivalent; /*   */
} ;
typedef struct IconButtonTemplate IconButtonTemplate;

struct LineEditTemplate {
   ControlTemplate ctlTemplate; /*   */
   Word maxSize; /*   */
   Ref defaultRef; /*   */
} ;
typedef struct LineEditTemplate LineEditTemplate;

struct ListTemplate {
   ControlTemplate ctlTemplate;
   Word listSize;
   Word listView;
   Word listType;
   Word listStart;
   ProcPtr listDraw;
   Word listMemHeight;
   Word listMemSize;
   Ref listRef;
   Ref colorTableRef; /*   */
} ;
typedef struct ListTemplate ListTemplate;

struct PictureTemplate {
   ControlTemplate ctlTemplate; /*   */
   Ref pictureRef; /*   */
} ;
typedef struct PictureTemplate PictureTemplate;

struct PopupTemplate {
   ControlTemplate ctlTemplate; /*   */
   Word titleWidth; /*   */
   Ref menuRef; /*   */
   Word initialValue; /*   */
   Ref colorTableRef; /*   */
} ;
typedef struct PopupTemplate PopupTemplate;

struct RadioButtonTemplate {
   ControlTemplate ctlTemplate; /*   */
   Ref titleRef; /*   */
   Word initalValue; /*   */
   Ref colorTableRef; /*   */
   KeystrokeRec keyEquivalent; /*   */
} ;
typedef struct RadioButtonTemplate RadioButtonTemplate;

struct ScrollBarTemplate {
   ControlTemplate ctlTemplate; /*   */
   Word maxSize; /*   */
   Word viewSize; /*   */
   Word initalValue; /*   */
   Ref colorTableRef; /*   */
} ;
typedef struct ScrollBarTemplate ScrollBarTemplate;

struct SizeBoxTemplate {
   ControlTemplate ctlTemplate; /*   */
   Ref colorTableRef; /*   */
} ;
typedef struct SizeBoxTemplate SizeBoxTemplate;

struct StaticTextTemplate {
   ControlTemplate ctlTemplate; /*   */
   Ref textRef; /*   */
   Word textSize; /*   */
   Word just; /*   */
} ;
typedef struct StaticTextTemplate StaticTextTemplate;

struct TextEditTemplate {
   ControlTemplate ctlTemplate;
   LongWord textFlags;
   Rect indentRect;
   CtlRecHndl vertBar;
   Word vertAmount;
   CtlRecHndl horzBar;
   Word horzAmount;
   Ref styleRef;
   Word textDescriptor;
   Ref textRef;
   LongWord textLength;
   LongWord maxChars;
   LongWord maxLines;
   Word maxCharsPerLine;
   Word maxHeight;
   Ref colorRef;
   Word drawMode;
   ProcPtr filterProcPtr;
} ;
typedef struct TextEditTemplate TextEditTemplate;

extern pascal LongWord CallCtlDefProc() inline(0x2C10,dispatcher);
extern pascal Handle CMLoadResource() inline(0x3210,dispatcher);
extern pascal void CMReleaseResource() inline(0x3310,dispatcher);
extern pascal void CtlBootInit() inline(0x0110,dispatcher);
extern pascal void CtlNewRes() inline(0x1210,dispatcher);
extern pascal void CtlReset() inline(0x0510,dispatcher);
extern pascal void CtlShutDown() inline(0x0310,dispatcher);
extern pascal void CtlStartUp() inline(0x0210,dispatcher);
extern pascal Boolean CtlStatus() inline(0x0610,dispatcher);
extern pascal Word CtlVersion() inline(0x0410,dispatcher);
extern pascal void DisposeControl() inline(0x0A10,dispatcher);
extern pascal void DragControl() inline(0x1710,dispatcher);
extern pascal Point DragRect() inline(0x1D10,dispatcher);
extern pascal void DrawControls() inline(0x1010,dispatcher);
extern pascal void DrawOneCtl() inline(0x2510,dispatcher);
extern pascal void EraseControl() inline(0x2410,dispatcher);
extern pascal Word FindControl () inline(0x1310,dispatcher);
extern pascal CtlRecHndl FindTargetCtl() inline(0x2610,dispatcher);
extern pascal void FutzCtls() inline(0x3610,dispatcher);
extern pascal LongProcPtr GetCtlAction() inline(0x2110,dispatcher);
extern pascal Word GetCtlDPage() inline(0x1F10,dispatcher);
extern pascal CtlRecHndl GetCtlHandleFromID() inline(0x3010,dispatcher);
extern pascal LongWord GetCtlID() inline(0x2A10,dispatcher);
extern pascal Word GetCtlMoreFlags() inline(0x2E10,dispatcher);
extern pascal Pointer GetCtlParamPtr() inline(0x3510,dispatcher);
extern pascal LongWord GetCtlParams() inline(0x1C10,dispatcher);
extern pascal LongWord GetCtlRefCon() inline(0x2310,dispatcher);
extern pascal Pointer GetCtlTitle() inline(0x0D10,dispatcher);
extern pascal Word GetCtlValue() inline(0x1A10,dispatcher);
extern pascal LongWord GrowSize() inline(0x1E10,dispatcher);
extern pascal void HideControl() inline(0x0E10,dispatcher);
extern pascal void HiliteControl() inline(0x1110,dispatcher);
extern pascal void InvalCtls() inline(0x3710,dispatcher);
extern pascal void KillControls() inline(0x0B10,dispatcher);
extern pascal CtlRecHndl MakeNextCtlTarget() inline(0x2710,dispatcher);
extern pascal void MakeThisCtlTarget() inline(0x2810,dispatcher);
extern pascal void MoveControl() inline(0x1610,dispatcher);
extern pascal CtlRecHndl NewControl() inline(0x0910,dispatcher);
extern pascal CtlRecHndl NewControl2() inline(0x3110,dispatcher);
extern pascal void NotifyControls() inline(0x2D10,dispatcher);
extern pascal void NotifyCtls() inline(0x2D10,dispatcher);
extern pascal Boolean SendEventToCtl() inline(0x2910,dispatcher);
extern pascal void SetCtlAction() inline(0x2010,dispatcher);
extern pascal FontHndl SetCtlIcons() inline(0x1810,dispatcher);
extern pascal void SetCtlID() inline(0x2B10,dispatcher);
extern pascal void SetCtlMoreFlags() inline(0x2F10,dispatcher);
extern pascal void SetCtlParamPtr() inline(0x3410,dispatcher);
extern pascal void SetCtlParams() inline(0x1B10,dispatcher);
extern pascal void SetCtlRefCon() inline(0x2210,dispatcher);
extern pascal void SetCtlTitle() inline(0x0C10,dispatcher);
extern pascal void SetCtlValue() inline(0x1910,dispatcher);
extern pascal void ShowControl() inline(0x0F10,dispatcher);
extern pascal Word TestControl() inline(0x1410,dispatcher);
extern pascal Word TrackControl() inline(0x1510,dispatcher);
#endif
